/*
 * Decompiled with CFR 0.152.
 */
package com.redpxnda.respawnobelisks.registry.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.math.Vector3f;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.redpxnda.respawnobelisks.registry.ModRegistries;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;

public class RuneCircleType
extends ParticleType<Options> {
    public static final Codec<Options> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("time").forGetter(options -> options.time), (App)Codec.INT.fieldOf("max_time").forGetter(options -> options.maxTime), (App)Codec.FLOAT.fieldOf("scale").forGetter(options -> Float.valueOf(options.scale)), (App)Vector3f.f_176762_.fieldOf("primary_color").forGetter(options -> options.primary), (App)Vector3f.f_176762_.fieldOf("secondary_color").forGetter(options -> options.secondary)).apply((Applicative)instance, Options::new));

    public RuneCircleType(boolean alwaysShow) {
        super(alwaysShow, Options.DESERIALIZER);
    }

    public Codec<Options> m_7652_() {
        return CODEC;
    }

    public record Options(int time, int maxTime, float scale, Vector3f primary, Vector3f secondary) implements ParticleOptions
    {
        public static final ParticleOptions.Deserializer<Options> DESERIALIZER = new ParticleOptions.Deserializer<Options>(){

            public Options fromCommand(ParticleType<Options> particleType, StringReader stringReader) throws CommandSyntaxException {
                stringReader.expect(' ');
                int time = stringReader.readInt();
                stringReader.expect(' ');
                int maxTime = stringReader.readInt();
                stringReader.expect(' ');
                float scale = stringReader.readFloat();
                stringReader.expect(' ');
                float x1 = stringReader.readFloat();
                stringReader.expect(' ');
                float y1 = stringReader.readFloat();
                stringReader.expect(' ');
                float z1 = stringReader.readFloat();
                stringReader.expect(' ');
                float x2 = stringReader.readFloat();
                stringReader.expect(' ');
                float y2 = stringReader.readFloat();
                stringReader.expect(' ');
                float z2 = stringReader.readFloat();
                return new Options(time, maxTime, scale, new Vector3f(x1, y1, z1), new Vector3f(x2, y2, z2));
            }

            public Options fromNetwork(ParticleType<Options> particleType, FriendlyByteBuf buf) {
                return new Options(buf.readInt(), buf.readInt(), buf.readFloat(), new Vector3f(buf.readFloat(), buf.readFloat(), buf.readFloat()), new Vector3f(buf.readFloat(), buf.readFloat(), buf.readFloat()));
            }
        };

        public ParticleType<Options> m_6012_() {
            return (ParticleType)ModRegistries.RUNE_CIRCLE_PARTICLE.get();
        }

        public void m_7711_(FriendlyByteBuf buf) {
            buf.writeInt(this.time);
            buf.writeInt(this.maxTime);
            buf.writeFloat(this.scale);
            buf.writeFloat(this.primary.m_122239_());
            buf.writeFloat(this.primary.m_122260_());
            buf.writeFloat(this.primary.m_122269_());
            buf.writeFloat(this.secondary.m_122239_());
            buf.writeFloat(this.secondary.m_122260_());
            buf.writeFloat(this.secondary.m_122269_());
        }

        public String m_5942_() {
            return Registry.f_122829_.m_7981_(this.m_6012_()).toString();
        }
    }
}

